<?php $__env->startSection('title', 'Plugins'); ?>


<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-datatable table-responsive pt-0">
            <table class="datatables-basic table">
                <thead>
                    <tr>
                        <th></th>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Cmd</th>
                        <th>Status</th>
                        <th>View</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        var ilsya = new velixs()
        var dbs = ilsya.datatables({
            url: "<?php echo e(route('plugins.ajax')); ?>",
            header: `Plugins Installed`,
            columns: [{
                    data: 'responsive_id'
                },
                {
                    data: 'name'
                },
                {
                    data: 'desc'
                },
                {
                    data: 'cmd'
                },
                {
                    data: 'status'
                },
                {
                    data: 'view'
                }
            ],
            btn: [{
                text: '<i class="ti ti-3d-cube-sphere me-sm-1" style="margin-top: -2px"></i> <span class="">More Plugins</span>',
                className: 'is-button-add btn btn-primary me-2 ',
            }],
        })

        $(document).on('click', ".is-change-status", function() {
            let command_name = $(this).data('name')
            let status = $(this).data('status')
            ilsya.ajax({
                type: "POST",
                url: "<?php echo e(route('plugins.change')); ?>",
                data: {
                    commands_name: command_name,
                    status: status
                },
                addons_success: function() {
                    dbs.ajax.reload()
                }
            })
        })
    </script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('cssvendor'); ?>
    <link rel="stylesheet" href="<?php echo asset('assets'); ?>/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
    <link rel="stylesheet" href="<?php echo asset('assets'); ?>/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
    <link rel="stylesheet" href="<?php echo asset('assets'); ?>/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css" />
    <link rel="stylesheet" href="<?php echo asset('assets'); ?>/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('jsvendor'); ?>
    <script src="<?php echo asset('assets'); ?>/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dash.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mahavikriid/wa.mahavikri.id/core/resources/views/plugins/index.blade.php ENDPATH**/ ?>